<?php
require_once __DIR__ . '/config.php';

header('Content-Type: text/plain; charset=utf-8');
header('Content-Disposition: attachment; filename="database_structure_' . date('Y-m-d_His') . '.sql"');

try {
    $pdo = new PDO(
        'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4',
        DB_USER, DB_PASS,
        [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]
    );
    
    echo "-- Database Structure Export (No Data)\n";
    echo "-- Database: " . DB_NAME . "\n";
    echo "-- Date: " . date('Y-m-d H:i:s') . "\n\n";
    
    echo "SET SQL_MODE = \"NO_AUTO_VALUE_ON_ZERO\";\n";
    echo "SET time_zone = \"+00:00\";\n\n";
    echo "/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;\n";
    echo "/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;\n";
    echo "/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;\n";
    echo "/*!40101 SET NAMES utf8mb4 */;\n\n";
    
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    
    foreach ($tables as $table) {
        echo "-- --------------------------------------------------------\n";
        echo "-- Table structure for table `$table`\n";
        echo "-- --------------------------------------------------------\n\n";
        echo "DROP TABLE IF EXISTS `$table`;\n";
        
        $create = $pdo->query("SHOW CREATE TABLE `$table`")->fetch(PDO::FETCH_ASSOC);
        if ($create) {
            echo $create['Create Table'] . ";\n\n";
        }
    }
    
    echo "/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;\n";
    echo "/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;\n";
    echo "/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;\n";
    
    echo "\n-- --------------------------------------------------------\n";
    echo "-- End of structure export\n";
    echo "-- --------------------------------------------------------\n";
    
} catch (Exception $e) {
    http_response_code(500);
    echo "-- Error: " . htmlspecialchars($e->getMessage()) . "\n";
}
