<?php
require_once __DIR__ . '/util.php';

$token = $_GET['token'] ?? '';
$sid   = $_GET['sid'] ?? '';
$ip    = $_GET['ip'] ?? '';
$view  = $_GET['view'] ?? 'login';
$msg   = $_GET['msg'] ?? '';

if ($token !== '') {
  ensure_token_row($token, $sid, $ip, 'open');
}

function e($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }
?><!doctype html>
<html><head><meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>User Authentication</title>
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

html {
    scroll-behavior: smooth;
}

body {
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
    color: #eee;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    padding: 20px;
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow-x: hidden;
}

body::-webkit-scrollbar {
    width: 8px;
}

body::-webkit-scrollbar-track {
    background: rgba(0, 0, 0, 0.2);
}

body::-webkit-scrollbar-thumb {
    background: rgba(139, 195, 74, 0.5);
    border-radius: 4px;
}

body::-webkit-scrollbar-thumb:hover {
    background: rgba(139, 195, 74, 0.7);
}

.wrap {
    max-width: 420px;
    width: 100%;
    margin: 0 auto;
    padding: 40px 35px;
    background: rgba(26, 26, 46, 0.95);
    border: 1px solid rgba(139, 195, 74, 0.3);
    border-radius: 16px;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.4),
                0 0 0 1px rgba(139, 195, 74, 0.1) inset;
    backdrop-filter: blur(10px);
    animation: fadeIn 0.5s ease-in-out;
    text-align: center;
}

@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(-20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

h2 {
    margin: 0 0 30px;
    font-size: 28px;
    font-weight: 700;
    background: linear-gradient(135deg, #8bc34a 0%, #4caf50 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.tabbar {
    margin-bottom: 25px;
    display: flex;
    gap: 10px;
    justify-content: center;
}

a.btn, .btn {
    display: inline-block;
    padding: 12px 24px;
    border: 2px solid rgba(139, 195, 74, 0.3);
    text-decoration: none;
    color: #ccc;
    border-radius: 8px;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    transition: all 0.3s ease;
    background: rgba(15, 15, 25, 0.4);
}

a.btn:hover {
    border-color: #8bc34a;
    color: #8bc34a;
    background: rgba(139, 195, 74, 0.1);
    transform: translateY(-2px);
}

.btn {
    border-color: #8bc34a;
    color: #8bc34a;
    background: rgba(139, 195, 74, 0.15);
    cursor: default;
}

input {
    width: 100%;
    padding: 14px 16px;
    margin: 10px 0;
    background: rgba(15, 15, 25, 0.8);
    border: 2px solid rgba(139, 195, 74, 0.2);
    border-radius: 8px;
    color: #eee;
    font-size: 15px;
    font-family: inherit;
    transition: all 0.3s ease;
    outline: none;
}

input:focus {
    border-color: #8bc34a;
    background: rgba(15, 15, 25, 0.95);
    box-shadow: 0 0 0 3px rgba(139, 195, 74, 0.1),
                0 0 20px rgba(139, 195, 74, 0.2);
    transform: translateY(-1px);
}

input::placeholder {
    color: #666;
}

label {
    display: block;
    margin-top: 15px;
    text-align: left;
    font-size: 13px;
    color: #aaa;
    cursor: pointer;
}

input[type=checkbox] {
    width: 18px;
    height: 18px;
    margin-right: 8px;
    vertical-align: middle;
    accent-color: #8bc34a;
    cursor: pointer;
}

button.btn {
    width: 100%;
    padding: 14px;
    margin-top: 20px;
    background: linear-gradient(135deg, #8bc34a 0%, #4caf50 100%);
    border: none;
    border-radius: 8px;
    color: #fff;
    font-size: 16px;
    font-weight: 700;
    cursor: pointer;
    text-transform: uppercase;
    letter-spacing: 1px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(139, 195, 74, 0.3);
    position: relative;
    overflow: hidden;
}

button.btn::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
    transform: translate(-50%, -50%);
    transition: width 0.6s, height 0.6s;
}

button.btn:hover::before {
    width: 300px;
    height: 300px;
}

button.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(139, 195, 74, 0.4);
}

button.btn:active {
    transform: translateY(0);
}

small {
    display: block;
    margin-top: 20px;
    color: #aaa;
    font-size: 13px;
    line-height: 1.6;
}

small a.btn {
    display: inline-block;
    padding: 8px 16px;
    margin-top: 10px;
    font-size: 13px;
}

div[style*="color:#9cf"] {
    margin: 15px 0;
    padding: 12px;
    background: rgba(139, 195, 74, 0.15);
    border-left: 3px solid #8bc34a;
    border-radius: 6px;
    color: #8bc34a !important;
    font-weight: 600;
    text-align: center;
}

div[style*="margin-top:8px"] {
    margin-top: 25px;
    padding-top: 20px;
    border-top: 1px solid rgba(139, 195, 74, 0.2);
}

div[style*="margin-top:8px"] small {
    font-size: 11px;
    color: #888;
    line-height: 1.8;
}

@media (max-width: 500px) {
    .wrap {
        padding: 30px 25px;
        margin: 10px;
    }
    
    h2 {
        font-size: 24px;
    }
}
</style>
</head>
<body>
<div class="wrap">
  <h2>User Panel</h2>
  
  <div class="tabbar">
    <?php if($view==='login'): ?>
      <span class="btn">Login</span>
      <a class="btn" href="motd_auth.php?view=register&token=<?=e($token)?>&sid=<?=e($sid)?>&ip=<?=e($ip)?>">Register</a>
    <?php else: ?>
      <a class="btn" href="motd_auth.php?view=login&token=<?=e($token)?>&sid=<?=e($sid)?>&ip=<?=e($ip)?>">Login</a>
      <span class="btn">Register</span>
    <?php endif; ?>
  </div>

  <?php if($msg!==''): ?>
    <div style="margin:6px 0;color:#9cf;"><?=e($msg)?></div>
  <?php endif; ?>

  <?php if($view==='login'): ?>
    <form method="post" action="submit.php">
      <input type="hidden" name="action" value="login">
      <input type="hidden" name="token" value="<?=e($token)?>">
      <input type="hidden" name="sid" value="<?=e($sid)?>">
      <input type="hidden" name="ip" value="<?=e($ip)?>">
      <input name="user" placeholder="Username" autocomplete="username" required>
      <input name="pass" placeholder="Password" type="password" autocomplete="current-password" required>
      <label style="display:block;margin-top:6px">
        <input type="checkbox" name="remember" value="1"> Remember me
      </label>
      <button class="btn" type="submit">Login</button>
    </form>
    <small>Don't have an account? <a class="btn" href="motd_auth.php?view=register&token=<?=e($token)?>&sid=<?=e($sid)?>&ip=<?=e($ip)?>">Create one</a></small>
  <?php else: ?>
    <form method="post" action="submit.php">
      <input type="hidden" name="action" value="register">
      <input type="hidden" name="token" value="<?=e($token)?>">
      <input type="hidden" name="sid" value="<?=e($sid)?>">
      <input type="hidden" name="ip" value="<?=e($ip)?>">
      <input name="user" placeholder="Username" autocomplete="username" required>
      <input name="pass" placeholder="Password" type="password" autocomplete="new-password" required>
      <button class="btn" type="submit">Create account</button>
    </form>
    <small><a class="btn" href="motd_auth.php?view=login&token=<?=e($token)?>&sid=<?=e($sid)?>&ip=<?=e($ip)?>">Back to Login</a></small>
  <?php endif; ?>

  <div style="margin-top:8px"><small>SteamID: <?=e($sid)?> &nbsp; IP: <?=e($ip)?></small></div>
</div>
</body></html>
