<?php
header('Content-Type: text/html; charset=windows-1252');
header('X-Frame-Options: ALLOWALL');
header('Content-Security-Policy: frame-ancestors *');

require_once __DIR__ . '/util.php';

$src   = $_POST ?: $_GET;
$view  = $src['view'] ?? 'login';
$user  = trim($src['username'] ?? '');
$pass  = (string)($src['password'] ?? '');
$sid   = $src['sid'] ?? '';
$ip    = $src['ip'] ?? '';
$server_name = trim($src['name'] ?? $src['server_name'] ?? ''); // Name from server (sent by plugin)
$remember = !empty($src['remember']) ? 1 : 0;
$token = $src['token'] ?? '';

function motd_out($title,$msg,$back='login'){
  echo '<!doctype html><html><head><meta http-equiv="Content-Type" content="text/html; charset=windows-1252"><title>',
        htmlspecialchars($title),
       '</title><style>body{background:#0b0b0b;color:#eee;font-family:Arial,Helvetica,sans-serif;margin:0}.w{max-width:640px;margin:28px auto;padding:18px 18px 26px;background:#111;border:1px solid #222}h3{text-align:center;margin:0 0 12px;color:#8bc34a;font-size:20px;font-weight:bold;text-transform:uppercase}p{text-align:center;margin:15px 0;font-size:14px;line-height:1.6;color:#ccc}.btnrow{margin-top:12px;text-align:center}button{padding:7px 14px;background:#8bc34a;border:1px solid #4caf50;color:#fff;font-size:14px;font-weight:bold;cursor:pointer;text-transform:uppercase;font-family:Arial,sans-serif}button:hover{background:#4caf50}</style></head><body><div class="w"><h3>',
        htmlspecialchars($title),
       '</h3><p>',$msg,'</p><div class="btnrow"><button onclick="window.location.href=\'motd_mini.php?view=',$back,'\'">Back</button></div></div></body></html>';
  exit;
}

try {
  if ($user==='' || $pass==='') motd_out('Error','Please fill username and password.',$view);
  
  // CRITICAL: Verify that entered username matches server player name
  // This prevents logging in with a different name than the one on server
  if ($server_name !== '' && strcasecmp($user, $server_name) !== 0) {
    motd_out('Error','Username must match your player name on server. Your server name is: '.htmlspecialchars($server_name),$view);
  }

  $pdo = db();
  $pdo->exec("CREATE TABLE IF NOT EXISTS counter_strike_users (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(32) NOT NULL UNIQUE,
    passhash VARCHAR(255) NOT NULL,
    steamid VARCHAR(64) NULL,
    ip VARCHAR(45) NULL,
    auto_login TINYINT(1) NOT NULL DEFAULT 0,
    last_login TIMESTAMP NULL DEFAULT NULL,
    created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  // asigură coloanele (compat cu vechiul 'password' / 'email' NOT NULL)
  $col = $pdo->query("SHOW COLUMNS FROM counter_strike_users LIKE 'passhash'")->fetch();
  if (!$col) {
    $hasOld = $pdo->query("SHOW COLUMNS FROM counter_strike_users LIKE 'password'")->fetch();
    if ($hasOld) {
      $pdo->exec("ALTER TABLE counter_strike_users CHANGE `password` `passhash` VARCHAR(255) NOT NULL");
    } else {
      $pdo->exec("ALTER TABLE counter_strike_users ADD `passhash` VARCHAR(255) NOT NULL AFTER username");
    }
  }
  $email = $pdo->query("SHOW COLUMNS FROM counter_strike_users LIKE 'email'")->fetch();
  if ($email && $email['Null'] === 'NO' && $email['Default'] === null) {
    $pdo->exec("ALTER TABLE counter_strike_users MODIFY `email` VARCHAR(255) NULL DEFAULT NULL");
  }
  foreach (['steamid VARCHAR(64) NULL','ip VARCHAR(45) NULL','auto_login TINYINT(1) NOT NULL DEFAULT 0','last_login TIMESTAMP NULL DEFAULT NULL'] as $want) {
    $name = strtok($want, ' ');
    if (!$pdo->query("SHOW COLUMNS FROM counter_strike_users LIKE '$name'")->fetch()) {
      $pdo->exec("ALTER TABLE counter_strike_users ADD $want");
    }
  }

  if ($view === 'register') {
    $st = $pdo->prepare("SELECT id FROM counter_strike_users WHERE username=? LIMIT 1");
    $st->execute([$user]);
    if ($st->fetch()) {
      // token FAIL pentru UI
      if ($token) {
        $pdo->prepare("UPDATE counter_strike_tokens SET status='FAIL', username=? WHERE token=?")->execute([$user,$token]);
      }
      motd_out('Register','Username already exists.','register');
    }
    $hash = password_hash($pass, PASSWORD_DEFAULT);
    $pdo->prepare("INSERT INTO counter_strike_users(username,passhash,steamid,ip,auto_login) VALUES(?,?,?,?,?)")
        ->execute([$user,$hash,$sid,$ip,$remember]);

    // opțional: marcăm OK și la register (dacă vrei efect imediat și aici)
    if ($token) {
      $pdo->prepare("UPDATE counter_strike_tokens SET status='OK', username=? WHERE token=?")->execute([$user,$token]);
    }
    motd_out('Register','Account created! You can close MOTD and use /user to log in.','login');

  } else { // login
    $st = $pdo->prepare("SELECT id,passhash FROM counter_strike_users WHERE username=? LIMIT 1");
    $st->execute([$user]);
    $row = $st->fetch(PDO::FETCH_ASSOC);

    if (!$row || !password_verify($pass, $row['passhash'])) {
      if ($token) {
        $pdo->prepare("UPDATE counter_strike_tokens SET status='FAIL', username=? WHERE token=?")->execute([$user,$token]);
      }
      motd_out('Login','Invalid credentials.','login');
    }

    $pdo->prepare("UPDATE counter_strike_users SET steamid=?, ip=?, auto_login=?, last_login=CURRENT_TIMESTAMP WHERE id=?")
        ->execute([$sid,$ip,$remember,$row['id']]);

    // marcăm tokenul ca OK -> pluginul vede și pornește efectul/sunetul
    if ($token) {
      $pdo->prepare("UPDATE counter_strike_tokens SET status='OK', username=? WHERE token=?")->execute([$user,$token]);
    }

    motd_out('Login','Login OK! You can close MOTD.','login');
  }

} catch (Throwable $e) {
  @file_put_contents(__DIR__.'/error_log', "[".date('c')."] ".$e->getMessage()."\n", FILE_APPEND);
  if ($token) {
    try { db()->prepare("UPDATE counter_strike_tokens SET status='FAIL' WHERE token=?")->execute([$token]); } catch(Throwable $__) {}
  }
  motd_out('Error','Unexpected error. Please try again.',$view);
}
