<?php
require_once __DIR__ . '/config.php';

function db(){
  static $pdo;
  if(!$pdo){
    $pdo = new PDO(
      'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4',
      DB_USER, DB_PASS,
      [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
       PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC]
    );
  }
  return $pdo;
}

function getv($k, $def=''){ return isset($_GET[$k]) ? trim((string)$_GET[$k]) : $def; }
function postv($k, $def=''){ return isset($_POST[$k]) ? trim((string)$_POST[$k]) : $def; }
function jres($arr){
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($arr, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  exit;
}

function ensure_token_row($token, $sid='', $ip='', $action='open'){
  $pdo = db();
  $stmt = $pdo->prepare("SELECT token FROM bs_auth_tokens WHERE token=? LIMIT 1");
  $stmt->execute([$token]);
  if(!$stmt->fetch()){
    $stmt = $pdo->prepare("INSERT INTO bs_auth_tokens (token, steamid, ip, action, status, username, remember, created_at, expires_at)
                           VALUES (?, ?, ?, ?, 'PENDING', NULL, 0, NOW(), DATE_ADD(NOW(), INTERVAL 10 MINUTE))");
    $stmt->execute([$token, $sid ?: null, $ip ?: null, $action]);
  }
}

function set_token_status($token, $status, $username=null, $remember=0){
  $pdo = db();
  $stmt = $pdo->prepare("UPDATE bs_auth_tokens SET status=?, username=?, remember=?, updated_at=NOW() WHERE token=?");
  $stmt->execute([$status, $username, (int)$remember, $token]);
}

function find_user_by_username($username){
  $pdo = db();
  $st = $pdo->prepare("SELECT * FROM bs_auth_users WHERE username=? LIMIT 1");
  $st->execute([$username]);
  return $st->fetch();
}

function find_user_by_sid_or_ip($sid, $ip){
  $pdo = db();
  $st = $pdo->prepare("SELECT * FROM bs_auth_users WHERE (steamid IS NOT NULL AND steamid=?) OR (ip IS NOT NULL AND ip=?) ORDER BY last_login DESC LIMIT 1");
  $st->execute([$sid ?: '', $ip ?: '']);
  return $st->fetch();
}

function create_user($username, $password, $sid='', $ip=''){
  $pdo = db();
  $hash = password_hash($password, PASSWORD_DEFAULT);
  $st = $pdo->prepare("INSERT INTO bs_auth_users (username, passhash, steamid, ip, created_at, last_login) VALUES (?,?,?,?,NOW(),NOW())");
  $st->execute([$username, $hash, $sid ?: null, $ip ?: null]);
  return $pdo->lastInsertId();
}

function touch_login($user_id, $sid='', $ip=''){
  $pdo = db();
  $st = $pdo->prepare("UPDATE bs_auth_users SET last_login=NOW(), steamid=COALESCE(?, steamid), ip=COALESCE(?, ip) WHERE id=?");
  $st->execute([$sid ?: null, $ip ?: null, $user_id]);
}
